/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv.bean;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.bean.MappingStrategy;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvToBean<T> {
    Map<Class<?>, PropertyEditor> editorMap = null;

    public List<T> parse(MappingStrategy<T> mapper2, Reader reader) {
        return this.parse(mapper2, new CSVReader(reader));
    }

    public List<T> parse(MappingStrategy<T> mapper2, CSVReader csv) {
        try {
            String[] line;
            mapper2.captureHeader(csv);
            ArrayList<T> list2 = new ArrayList<T>();
            while (null != (line = csv.readNext())) {
                T obj = this.processLine(mapper2, line);
                list2.add(obj);
            }
            return list2;
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing CSV!", e);
        }
    }

    protected T processLine(MappingStrategy<T> mapper2, String[] line) throws IllegalAccessException, InvocationTargetException, InstantiationException, IntrospectionException {
        T bean = mapper2.createBean();
        for (int col = 0; col < line.length; ++col) {
            String value2 = line[col];
            PropertyDescriptor prop = mapper2.findDescriptor(col);
            if (null == prop) continue;
            Object obj = this.convertValue(value2, prop);
            prop.getWriteMethod().invoke(bean, obj);
        }
        return bean;
    }

    protected Object convertValue(String value2, PropertyDescriptor prop) throws InstantiationException, IllegalAccessException {
        PropertyEditor editor = this.getPropertyEditor(prop);
        Object obj = value2;
        if (null != editor) {
            editor.setAsText(value2.trim());
            obj = editor.getValue();
        }
        return obj;
    }

    private PropertyEditor getPropertyEditorValue(Class<?> cls) {
        PropertyEditor editor;
        if (this.editorMap == null) {
            this.editorMap = new HashMap();
        }
        if ((editor = this.editorMap.get(cls)) == null) {
            editor = PropertyEditorManager.findEditor(cls);
            this.addEditorToMap(cls, editor);
        }
        return editor;
    }

    private void addEditorToMap(Class<?> cls, PropertyEditor editor) {
        if (editor != null) {
            this.editorMap.put(cls, editor);
        }
    }

    protected PropertyEditor getPropertyEditor(PropertyDescriptor desc) throws InstantiationException, IllegalAccessException {
        Class<?> cls = desc.getPropertyEditorClass();
        if (null != cls) {
            return (PropertyEditor)cls.newInstance();
        }
        return this.getPropertyEditorValue(desc.getPropertyType());
    }
}

